/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/

/**
 * @fileOverview
 * This is a wrapper for Service functions.
 *
 * Attribute like @[description] used here to generate help.chm file.
 */

if (typeof(Util) == "undefined")
	Util = {};

/**
 * Object that represent Service functions.
 * @class Util.Service
 */
Util.Service = 
{
	/**
	 * Service start types.
	 * @type Object
	 * @field
	 */
	StartType:
	{
		SERVICE_BOOT_START: 0,
		SERVICE_SYSTEM_START: 1,
		SERVICE_AUTO_START: 2,
		SERVICE_DEMAND_START: 3,
		SERVICE_DISABLED: 4
	},

	/**
	 * Query service.
	 * @param name Service name.
	 * @returns Object with service properties or false.
	 */
	QuerySvc: function(/**String*/ name) /**Object*/
	{
		return _QuerySvc(name);
	},
	
	/**
	 * Change service start type.
	 * @param name Service name.
	 * @param startType Service start type.
	 * @returns Boolean. True if success
	 */
	ChangeSvcStartType: function(/**String*/ name, /**Number*/startType) /**Boolean*/
	{
		return _ChangeSvcStartType(name, startType);
	},
	
	/**
	 * Start service.
	 * @param name Service name.
	 * @param start Start(true) or stop.
	 * @returns Boolean. True if success
	 */
	StartService: function(/**String*/ name, /**Boolean*/ start) /**Boolean*/
	{
		return _ServiceStart(name, start);
	}
}