/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/

/**
 * @fileOverview
 * This is a wrapper for Scheduler functions.
 *
 * Attribute like @[description] used here to generate help.chm file.
 */

if (typeof(Util) == "undefined")
	Util = {};

/**
 * Object that represent Scheduler functions.
 * @class Util.Scheduler
 */
Util.Scheduler = 
{
	/**
	 * Enumerate Scheduled Tasks in system
	 * @returns Array of tasks. Null if error.
	 */
	EnumerateScheduledTasks: function() /**Array*/
	{
		return _EnumerateScheduledTasks();
	},

	/**
	 * Enable or disable scheduled task
	 * @param folder Root task folder.
	 * @param task Task name
	 * @param enable Boolean. True to enable task
	 * @returns Error code. 0 if success. Number
	 */
	EnableScheduledTask: function(/**String*/folder, /**String*/task, /**Boolean*/enable) /**Number*/
	{
		return _EnableScheduledTask(folder, task, enable);
	},

	/**
	 * Create scheduled task
	 * @param taskName Task name
	 * @param executablePath Executable path
	 * @param dateTime Set the task to start at a certain time. The time format should be YYYY-MM-DDTHH:MM:SS(+-)(timezone).
	 * @returns Error code. 0 if success.
	 */
	ScheduleTask: function(/**String*/ taskName, /**String*/ executablePath, /**String*/ dateTime) /**Number*/
	{
		var startTime = dateTime.format(dateFormat.masks.isoDateTime);
		return _ScheduleTask(taskName, executablePath, startTime);
	},

	/**
	 * Set scheduled task trigger type
	 * @param folder Root task folder.
	 * @param task Task name
	 * @param triggerType  TASK_TRIGGER_MONTHLY(4), TASK_TRIGGER_WEEKLY(3), TASK_TRIGGER_DAILY (2), TASK_TRIGGER_TIME(1)
	 * @returns Error code. 0 if success.
	 */
	SetTaskTriggerType: function(/**String*/ folder, /**String*/ task, /**Number*/ triggerType) /**Number*/
	{
		return _SetTaskTriggerType(folder, task, triggerType);
	}	
}