/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/ 

/**
 * @fileOverview
 * This is a file with scenario common functions.
 *
 * Attribute like @[description] used here to generate help.chm file.
 */

/**
 * Add scenario information to output.
 */
function Info()
{
	if (typeof(Scenario.currentScenario) != "undefined")
	{
		scenarioName = Scenario.currentScenario.name;
		if(l1) Log1("Scenario '" + scenarioName + "'");

		if (typeof(Scenario.currentScenario.parts) == "undefined")
		{
			//if(l0) Log("Scenatio is empty");
			return;
		}

		if(l2) Log2("Configuration");
		for(var i = 0; i < Scenario.currentScenario.parts.length; i++)
		{
			var part = Scenario.currentScenario.parts[i];
			if(l2) Log2("Part: " + part.name);
			if(l2) Log2("\tEnabled: " + part.enabled);
			var actions = "";
			for(var j = 0; j < part.actions.length; j++)
			{
				var action = part.actions[j];
				actions += action.name;
				if (j <part.actions.length - 1) actions += ", ";
			}
			if(l2) Log2("\tAvailable actions: " + actions);
		}
	}
	else
	{
		if(l1) Log1("Current scenario is not specified");
	}
}

var queryResult = [];

/**
 * Execute scenario
 * @param scen Scenario to execute.
 * @returns Array of results or nothing.
 */
function Execute(/**Object*/ scen) /**Array*/
{
	function _launch(scen, part, actionName)
	{
		for(var i = 0; i < part.actions.length; i++)
		{
			var action = part.actions[i];
			if (action.name == actionName)
			{
				scen.dataFolderPath = Util.Scenario.GetDataFolderPath(scen.name, actionName);
				action.handler.apply(scen, action.arguments);
			}
		}
	}
	
	Scenario.currentScenario = scen;
	
	if (typeof(action) == "undefined")
	{
		Log("No Action specified");
		Log("Default action is 'query'");
		action = "query";
	}

	Info();

	if (typeof(Scenario.currentScenario) != "undefined")
	{	
		var scen = Scenario.currentScenario;
	
		if(l1) Log1("Running scenario '" + scen.name + "', action '" + action + "'");
	
		Util.IO.CreateDirectory(Util.Scenario.GetDataFolderPath(scen.name, "query"));
		
		if (scen.CheckProgramInstalled())
		{
			Util.IO.CreateDirectory(Util.Scenario.GetDataFolderPath(scen.name, "backup"));
		}
		
		queryResult = [];
		
		scen.dataFolderPath = Util.Scenario.GetDataFolderPath(scen.name, action);
		for(var member in scen)
		{
			if (member.toLowerCase() == action.toLowerCase())
			{
				if(l1) Log1("Action found");	
				if (scen[member + "Ext"])
					scen[member + "Ext"]();
				scen[member]();
			}
		}

		if(l1) Log1("Result");
	
		for(var i = 0; i < queryResult.length; i++)
		{
			var qr = queryResult[i];
			if (l0) Log(qr.msg);
		}
		
		return queryResult;
	}
}


if (typeof(Util) == "undefined")
	Util = {};

/**
 * Object that represent Scenario functions.
 * @class Util.Scenario
 */
Util.Scenario = 
{
	/**
	 * Get data folder path for scenario.
	 * @param scenarioName Scenario name.
	 * @param actionName Action name.
	 * @returns Data folder path.
	 */
	GetDataFolderPath: function(/**String*/ scenarioName, /**String*/ actionName) /**String*/
	{
		var actionLwc = actionName.toLowerCase();
		if (actionLwc == "backup" || actionLwc == "restore")
		{
			return Util.IO.GetCurrentDirectory() + "\\Scenarios\\" + scenarioName + ".backup";
		}

		return Util.IO.GetCurrentDirectory() + "\\Scenarios\\" + scenarioName;
	},
	
	/**
	 * Get scenario by its name.
	 * @param name Scenario name.
	 * @returns Scenario object.
	 */
	GetScenarioForName: function(/**String*/ name) /**Object*/
	{
		for(i in Scenario)
		{
			var scenario = Scenario[i];
			if (scenario.name && scenario.name == name)
			{
				return scenario;
			}
		}
		return null;
	},
	
	/**
	 * Initialize Scenario.
	 * @param scen Scenario.
	 */
	InitializeScenario: function(/**Object*/ scen)
	{
		this._initializeScenario(scen, scen);
	},
	
	_initializeScenario: function(scen, obj)
	{
		if (obj && obj.inherits)
		{
			for(var i = 0; i < obj.inherits.length; i++)
			{
				var base = obj.inherits[i];
				for(var member in base)
				{
					if (member != "inherits")
					{
						if (scen[member] === undefined)
						{
							if (l2) Log2("Appending member '" + member + "' to scenario '" + scen.name + "'");
							scen[member] = base[member];
						}
					}
				}
				this._initializeScenario(scen, base);
			}
		}
	},

	/**
	 * Has current scenario action or not.
	 * @param name Action name.
	 * @returns Boolean. True if has
	 */
	HasAction: function(/**String*/ name) /**Boolean*/
	{
		var scen = Scenario.currentScenario;
		if (scen && scen.actions.length)
		{
			for(var i = 0; i < scen.actions.length; i++)
			{
				if (scen.actions[i] == name)
					return true;
			}
		}
		return false;
	}
}

