﻿/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/

/**
 * @fileOverview
 * This is a wrapper for locale. Contain functions to get localized strings.
 *
 * Attribute like @[description] used here to generate help.chm file.
 */
 
if (typeof(Util) == "undefined")
	Util = {};

/**
 * Object that represent locale.
 * @class Util.Locale
 */
Util.Locale = 
{
	/**
	 * Dictionary
	 * @type Dictionary of String
	 * @field
	 */
	Strings: {},

	/**
	 * Default Locale
	 * @type String
	 * @field
	 */
	defaultLocale: "en",

	/**
	 * User Locale
	 * @type String
	 * @field
	 */
	userLocale: "",

	/**
	 * Set Locale
	 * @param ulocale Locale to set
	 */	
	SetLocale: function(/**String*/ ulocale)
	{
		this.userLocale = ulocale;
	},

	/**
	 * Get Locale name.
	 * @returns Locale name.
	 */
	GetLocale: function() /**String*/
	{
		return  (this.userLocale != "") ? this.userLocale : _GetCurrentLanguage();
	},

	/**
	 * Get info file path.
	 * @param subject
	 * @returns Path to file.
	 */
	GetInfoFileName: function(/**String*/ subject) /**String*/
	{
		var fileName = Util.IO.GetCurrentDirectory() + "\\Locale\\" + subject + "." + this.GetLocale() + ".html";
		if (Util.IO.CheckFileExists(fileName))
			return fileName;
		return Util.IO.GetCurrentDirectory() + "\\Locale\\" + subject + "." + this.defaultLocale + ".html";
	},

	/**
	 * Load dictionary for locale
	 * @returns Dictionary
	 */
	Load: function()
	{
		this.LoadLocale(this.defaultLocale);	
		
		var locale = this.GetLocale();
		
		if (locale != this.defaultLocale)
		{
			this.LoadLocale(locale);
		}
		
		return this.Strings;
	},

	/**
	 * Load selected locale
	 * @param locale name.
	 * @returns True if success.
	 */
	LoadLocale: function(/**String*/ locale) /**Boolean*/
	{
		var files = Util.IO.GetFilesInFolder(Util.IO.GetCurrentDirectory() + "/Locale");
		
		for(var i = 0; i < files.length; i++)
		{
			var fileName = files[i];
			var pos = fileName.indexOf("." + locale + ".json");
			if (pos != -1)
			{
				var prefix = fileName.substring(0, pos);
				this.ParseFile("Locale/" + fileName, prefix);
			}
		}			
		return true;
	},
	
	/**
	 * Parse dictionary from file
	 * @param fileName Path to file.
	 * @param prefix Prefix to use.
	 * @returns True if success.
	 */
	ParseFile: function(/**String*/ fileName, /**String*/ prefix) /**Boolean*/
	{
		var contents = Util.IO.ReadFileUTF8(fileName);
		if (contents)
		{
			try
			{
				// var localStrings = JSON.parse(contents);
				eval("var localStrings = " + contents);
				if (localStrings)
				{
					for (var attr in localStrings)
					{
						this.Strings[prefix + "." + attr] = localStrings[attr];
					}
				}
			}
			catch(e)
			{
				Error("Locale file '" + fileName + "'syntax is incorrect: " + e);
			}
		}
		return true;
	},

	/**
	 * Get localized string from dictionary.
	 * @param str Localized string id.
	 * @returns Localized string.
	 */
	GetString: function(/**String*/ str) /**String*/
	{
		if (this.Strings[str] != undefined)
		{
			return this.Strings[str];
		}
		
		return "No such string loaded: " + str;
	},

	/**
	 * Output dependencies.
	 * @param prefix
	 */
	OutputDependencies: function(/**String*/ prefix)
	{
		if(typeof(_dependencies)!="undefined")
		{
			var localePath = Util.IO.GetCurrentDirectory() + "/Locale";
			var files = Util.IO.GetFilesInFolder(localePath);
			for(var i = 0; i < files.length; i++)
			{
				var fileName = files[i];
				if (fileName.indexOf(prefix) == 0)
					_dependencies[fileName] = {name: fileName, path: localePath + "/" + fileName};
			}
		}
	}
}

/**
 * Get localized string from dictionary.
 * @param str Localized string id.
 * @returns Localized string.
 */
function S(/**String*/ str) /**String*/ 
{
	return Util.Locale.GetString(str);
}

/**
 * Get localized string from dictionary and format it with arguments.
 * @param str Localized string id.
 * @param args Arguments used in formatted string.
 * @returns Localized string.
 */
function SF(/**String*/ str, /**Array*/ args) /**String*/ 
{
	return S(str).format(args);
}