/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/

/**
 * @fileOverview
 * This is a wrapper for GroupPolicy functions.
 *
 * Attribute like @[description] used here to generate help.chm file.
 */

if (typeof(Util) == "undefined")
	Util = {};

/**
 * Object that represent GroupPolicy functions.
 * @class Util.GroupPolicy
 */
Util.GroupPolicy = 
{
	// GroupPolicy Sections
	GPO_SECTION_ROOT: 0,
	GPO_SECTION_USER: 1,
	GPO_SECTION_MACHINE: 2,
	
	// GroupPolicy file restriction levels
	GPO_LEVEL_UNKNOWN: 0,
	GPO_LEVEL_DISALLOWED: 1,
	GPO_LEVEL_BASIC_USER: 2,
	GPO_LEVEL_UNRESTRICTED: 3,
	GPO_LEVEL_DELETE: 4,

	/**
	 * Set path restriction policy of file by its path.
	 * @param path Path to file.
	 * @param level Restriction level.
	 * @returns New level if success or current level if fail.
	 */
	SetPathRestrictionPolicy: function(/**String*/ path, /**Number*/ level) /**Number*/
	{
		return _GPOSetPathRestrictionPolicy(path, level); // add\change\delete
	},
	
	/**
	 * Query restriction policy level of file by its path.
	 * @param path Path to file.
	 * @returns Current level.
	 */
	QueryPathRestrictionPolicyLevel: function(/**String*/ path) /**Number*/
	{
		return _GPOQueryPathRestrictionPolicyLevel(path); // status\unknown
	}
}