/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/

/**
 * @fileOverview
 * This is a wrapper for File Security functions.
 *
 * Attribute like @[description] used here to generate help.chm file.
 */
 
if (typeof(Util) == "undefined")
	Util = {};

/**
 * Object that represent FileSecurity functions.
 * @class Util.FileSecurity
 */
Util.FileSecurity = 
{
	/**
	 * Grant access to file by its path.
	 * @param fileName Path to file.
	 * @returns Boolean. True if success
	 */
	GrantFileAccess: function(/**String*/ fileName) /**Boolean*/
	{
		return _GrantFileAccess(fileName);
	},
	
	/**
	 * Deny access to file by its path.
	 * @param fileName Path to file.
	 * @returns Boolean. True if success
	 */
	DenyFileAccess: function(/**String*/ fileName) /**Boolean*/
	{
		return _DenyFileAccess(fileName);
	},
	
	/**
	 * Is file access denied.
	 * @param fileName Path to file.
	 * @returns Boolean. True if success
	 */
	IsFileAccessDenied: function(/**String*/ fileName) /**Boolean*/
	{
		return _IsFileAccessDenied(fileName);
	}
}