﻿/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/

/**
 * @fileOverview
 * This is a wrapper for Curl functions.
 *
 * Attribute like @[description] used here to generate help.chm file.
 */

if (typeof(Util) == "undefined")
	Util = {};

/**
 * Object that represent curl functions.
 * @class Util.Curl
 */
Util.Curl = 
{
	/**
	 * Params of current curl object.
	 * @type Object
	 * @field
	 */
	Params: function()
	{
	},
	
	/**
	 * Execute curl with query
	 * @param query Query for curl.
	 * @returns Curl process exit code.
	 */
	Execute: function(/**String*/ query) /**Number*/
	{
		var command = '"' + _GetIceJSPath() + 'Bin/curl.exe" ' + query;
		_Log(command);
		return Util.Shell.Run(command);
	},

	/**
	 * Do post operation with curl params
	 * @param cp Curl params.
	 * @returns Curl process exit code.
	 */
	Post: function(/**CurlParams*/ cp)
	{
		/*
			curl --cookie session.sess --cookie-jar session.sess -d @sugar.txt http://url/index.php
		*/
		var q = "";
		var tempFile = null;
		if(cp.session != null)
		{
			q += '--cookie "' + cp.session + '" --cookie-jar "' + cp.session + '" ';
		}
		if(cp.vars != null && cp.vars.length > 0)
		{
			for(var i = 0; i < cp.vars.length; i++)
			{
				q += " -d " + cp.vars[i];
			}
			q += " ";
		}
		else if(cp.postData != null)
		{
			//i do not use cp.directory - will create temp file near caller
			tempFile = "tempPostData.dat";
			Util.IO.WriteFile(tempFile, cp.postData);
			q += "-d @" + tempFile + " ";
		}
		else if(cp.postFile != null)
		{
			// SEND IT AS BINARY DATA !
			// WE SENDING DATA FROM FILE, NOT AS ATTACHMENT
			q += "--data-binary @" + cp.postFile + " ";
		}
		if(cp.output != null)
		{
			q += '-o "' + cp.output + '" ';
		}
		q += cp.url;
		var res = this.Execute(q);
		if(tempFile != null)
		{
			Util.IO.DeleteFile(tempFile);
		}
		return res;
	},
	
	/**
	 * Do get operation with curl params
	 * @param cp Curl params.
	 * @returns Curl process exit code.
	 */
	Get: function(/**CurlParams*/ cp)
	{
		/*
			--cookie session.sess --cookie-jar session.sess --output "d:\response.htm" -G -d module=Users -d action=DetailView http://url/i.php
		*/
		var q = "";
		if(cp.session != null)
		{
			q += '--cookie "' + cp.session + '" --cookie-jar "' + cp.session + '" ';
		}
		if(cp.vars != null && cp.vars.length > 0)
		{
			q += "-G";
			for(var i = 0; i < cp.vars.length; i++)
			{
				q += " -d " + cp.vars[i];
			}
			q += " ";
		}
		if(cp.output != null)
		{
			q += '-o "' + cp.output + '" ';
		}
		q += cp.url;
		return this.Execute(q);
	}	
}

Util.Curl.Params.prototype = 
{
	/**
	 * Url. String. Must present
	 * @type Object
	 * @field
	 */
	url: null,
	
	/**
	 * possible arrays of vars
	 * @type Object
	 * @field
	 */
	vars: null,
	
	/**
	 * if get or post vars contain invalid char for curl - 
	 * it is better to prepare url encoded string 
	 * @type String
	 * @field
	 */
	postData: null,
	
	/**
	 * Path to file with data, to send binary
	 * @type String
	 * @field
	 */
	postFile: null,
	
	/**
	 * Curl operations will create file with response if set, path to file.
	 * @type String
	 * @field
	 */
	output: null,
	
	/**
	 * Session name, if not present - each action will open new session
	 * try to compose unique name without invalid curl and command line chars
	 * will create file with this name with session information.
	 * @type String
	 * @field
	 */
	session: null,
	
	/**
	 * Directory where curl.exe to use
	 * @type String
	 * @field
	 */
	directory: ""
}
