﻿/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/
 
if (typeof(g_executeInBatch) == "undefined")
{
	Include("Wrappers/Common.js")
	Include("Controllers/Controller.js");
}	

if (typeof(Scenario) == "undefined")
	Scenario = {};

Scenario.WindowsUpdate = 
{
	name: 			"Windows.Update",
	displayName:    "Windows",
	version: 		"0.1",
	description: 	"Checks if Windows Update is enabled and allows freezing it",
	link:			"http://www.updatefreezer.org/index.php?id=23",
	icon:			"Resources/Windows.Update.png",
	actions:		["query", "backup", "restore", "enable", "disable"],
	
	registry: [{section: Util.Registry.HKLM, key: "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\WindowsUpdate\\Auto Update", value: "AUOptions"}],

	inherits: [ScenarioController, RegistryController],
	
//#region Implementation	
	NOTSET:			 0,
	DISABLED: 		 1,
	NOTIFYONLY: 	 2,
	DOWNLOADONLY:    3,
	AUTOMATIC: 		 4,
//#endregion	
	
	
//#region Actions
	Query: function()
	{
		this.QueryRegistry(true);
		this.LogUpdaterStatus();
	},
	
	Disable: function()
	{
		this.ChangeRegistry(1);
	},
	
	Enable: function()
	{
		this.ChangeRegistry(2);
	},
	
	Backup: function()
	{
		this.QueryRegistry();
	},
	
	Restore: function()
	{
		this.ChangeRegistry();
	},
	
	SetNotSet: function()
	{
		this.ChangeRegistry(0);
	},
	
	SetDisabled: function()
	{
		this.ChangeRegistry(1);
	},	
	
	SetNotifyOnly: function()
	{
		this.ChangeRegistry(2);
	},	
	
	SetDownloadOnly: function()
	{
		this.ChangeRegistry(3);
	},	
	
	SetAutomatic: function()
	{
		this.ChangeRegistry(4);
	},
//#endregion

	LogRegistryResult: function(result)
	{
		if (result && result.values && result.values.length && result.values[0].data > 1)
		{
			this.updaterEnabled = true;
			queryResult.push({msg: S("Common.RegistryEnabled")});
		}
		else
		{
			queryResult.push({msg: S("Common.RegistryDisabled")});
		}	
	},

	GetScenarioInfo: function()
	{
		Scenario.currentScenario = this;
		
		if (this.IsProgramInstalled)
		{
			if (false == this.IsProgramInstalled())
			{
					return {name: this.name, 
							displayName: this.displayName,
							icon: this.icon,
							status: S("UI.NotInstalled"),
							link: this.link};
			}
		}

		// do backup if first time
		var backupFolder = Util.Scenario.GetDataFolderPath(this.name, "backup");		
		var files = _GetFilesInFolder(backupFolder);
		if (files.length == 0)
		{
			action = "backup";
			Execute(this);
		}
	
		// do query
		this.updaterEnabled = false;
		action = "query";
		var status = Execute(this);
		
		// get current state of updates
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.GetRegistryDataFileName());
		var result = Util.IO.ReadJsonFromFile(dataFileName);
		var state = result.values[0].data;
		
		var actionInfo = 
		{
			name: this.name,
			displayName: this.displayName,
			icon: this.icon,
			status: status,
			link: this.link,
		    actions: [
				{
					action: "SetNotSet",
					buttonName: "NotSet",
					active: state == this.NOTSET
				},
				{
					action: "SetDisabled", 
					buttonName: "Disabled", 
					active: state == this.DISABLED
				},
				{
					action: "SetNotifyOnly", 
					buttonName: "NotifyOnly", 
					active: state == this.NOTIFYONLY
				},
				{
					action: "SetDownloadOnly", 
					buttonName: "DownloadOnly", 
					active: state == this.DOWNLOADONLY
				},
				{
					action: "SetAutomatic", 
					buttonName: "Automatic", 
					active: state == this.AUTOMATIC
				}
			]
		};
	
		return actionInfo;
	}		
};

Util.Scenario.InitializeScenario(Scenario.WindowsUpdate);

if (typeof(g_executeInBatch) == "undefined")
{
	Util.Locale.Load();
	Execute(Scenario.WindowsUpdate);
}

Scenario.WindowsUpdate.OutputDependencies();
