/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/ 
 
if (typeof(g_executeInBatch) == "undefined")
{
	Include("Wrappers/Common.js")
	Include("Controllers/Controller.js");
}

if (typeof(Scenario) == "undefined")
	Scenario = {};
	
Scenario.SkypeUpdater = 
{
	name: 			"Skype.Updater",
	displayName:    "Skype",
	version: 		"1.0",
	description: 	"Checks if any of Skype Update facilities are enabled and allows freezing of these facilities",
	link:			"http://www.updatefreezer.org/index.php?id=4",
	icon:			"Resources/Skype.Updater.png",
	actions:		["query", "backup", "restore", "enable", "disable"],

	programs: [{path: "%PROGRAMFILES%\\Skype\\Phone\\Skype.exe"}],
	registry: [{section: Util.Registry.HKLM, key: "SOFTWARE\\Policies\\Skype\\Phone", value: "DisableVersionCheckPolicy"}],
	services: [{name: "SkypeUpdate"}],
	updaterFile: "%USERPROFILE%\\AppData\\Local\\Temp\\SkypeSetup.exe",
	
	skypeDataFileName: "Skype.Updater.json",
	
	inherits: [ScenarioController, RegistryController, ServiceController],

//#region Enums
	ENABLED:		 0,
	DISABLEDREG:	 1,
	DISABLEDFILE: 	 2,
	DISABLEDSERVICE: 3,
//#endregion

//#region Actions
	QuerySkype: function()
	{
		var result = this.QueryRegistry(true);
		var serviceResult = this.QueryServices();
		if (Util.FileSecurity.IsFileAccessDenied(Util.Shell.ExpandEnvironmentString(this.updaterFile))
			|| serviceResult.values[0].startType == Util.Service.StartType.SERVICE_DISABLED)
		{
			this.state = this.DISABLEDFILE;
		}
		else 
		{
			if (result && result.values && result.values[0].data == 1)
			{
				this.state = this.DISABLEDREG
			}
			else
			{
				this.state = this.ENABLED;
				this.updaterEnabled = true;			
			}
		}
	},
	
	Query: function()
	{
		if (!this.CheckProgramInstalled())
		{
			return false;
		}
		
		this.QuerySkype();
		
		if (this.updaterEnabled)
		{
			queryResult.push({msg: "<b>" + S("Skype.Updater.UpdaterEnabled") + "</b>"});
		}
		else
		{
			queryResult.push({msg: "<b>" + S("Skype.Updater.UpdaterDisabled") + "</b>"});
		}		
		
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.skypeDataFileName);
		Util.IO.WriteJsonToFile(dataFileName, this.state);		
	},
	
	ChangeUpdater: function(state)
	{
		this.state = state;
		updaterExe = Util.Shell.ExpandEnvironmentString(this.updaterFile);
		switch (state)
		{
			case this.ENABLED:
				this.ChangeServices(Util.Service.StartType.SERVICE_AUTO_START);
				this.ChangeRegistry(0);
				Util.FileSecurity.GrantFileAccess(updaterExe);
				break;
				
			case this.DISABLEDREG:
				this.ChangeServices(Util.Service.StartType.SERVICE_AUTO_START);
				this.ChangeRegistry(1);
				Util.FileSecurity.GrantFileAccess(updaterExe);
				break;
				
			case this.DISABLEDFILE:
				if (!Util.IO.CheckFileExists(updaterExe))
				{
					Util.IO.WriteFile(updaterExe, "empty");
				}
				this.ChangeRegistry(1);
				this.ChangeServices(Util.Service.StartType.SERVICE_DISABLED);
				Util.FileSecurity.DenyFileAccess(updaterExe);
				break;	
		}
	},
	
	MajorOnly: function()
	{
		this.ChangeUpdater(this.DISABLEDREG);
	},
	
	Disable: function()
	{
		this.ChangeUpdater(this.DISABLEDFILE);
	},
	
	Enable: function()
	{
		this.ChangeUpdater(this.ENABLED);
	},
		
	Backup: function()
	{
		this.Query();
	},
	
	Restore: function()
	{
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.skypeDataFileName);
		var p = Util.IO.ReadJsonFromFile(dataFileName);		
		this.ChangeUpdater(p);
	},
//#endregion	
	
	GetScenarioInfo: function()
	{
		Scenario.currentScenario = this;
		
		if (this.IsProgramInstalled)
		{
			if (false == this.IsProgramInstalled())
			{
					return {name: this.name, 
							displayName: this.displayName,
							icon: this.icon,
							status: S("UI.NotInstalled"),
							link: this.link};
			}
		}

		// do backup if first time
		var backupFolder = Util.Scenario.GetDataFolderPath(this.name, "backup");		
		var files = _GetFilesInFolder(backupFolder);
		if (files.length == 0)
		{
			action = "backup";
			Execute(this);
		}
	
		// do query
		this.updaterEnabled = false;
		action = "query";
		var status = Execute(this);
		
		// get current state of updates
		var dataFileName = Util.IO.CombinePath(this.dataFolderPath, this.skypeDataFileName);
		var result = Util.IO.ReadJsonFromFile(dataFileName);
		var state = result;
		
		var actionInfo = 
		{
			name: this.name,
			displayName: this.displayName,
			icon: this.icon,
			status: status,
			link: this.link,
		    actions: [
				{
					action: "Disable", 
					buttonName: "Disabled", 
					active: this.state == this.DISABLEDFILE
				},		   
				{
					action: "MajorOnly", 
					buttonName: "Major", 
					active: this.state == this.DISABLEDREG
				},
				{
					action: "Enable",
					buttonName: "Enabled",
					active: this.state == this.ENABLED
				}
			]
		};
	
		return actionInfo;
	}	
};

Util.Scenario.InitializeScenario(Scenario.SkypeUpdater);

if (typeof(g_executeInBatch) == "undefined")
{
	Util.Locale.Load();
	Execute(Scenario.SkypeUpdater);
}

Scenario.SkypeUpdater.OutputDependencies();

