/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/
 
if (typeof(g_executeInBatch) == "undefined")
{
	Include("Wrappers/Common.js")
	Include("Controllers/Controller.js");
}

if (typeof(Scenario) == "undefined")
	Scenario = {};

function _GetOperaRootFolder()
{
	var path = Util.Shell.ExpandEnvironmentString("%PROGRAMFILES%\\Opera");
	var status = Util.IO.ReadFile(Util.IO.CombinePath(path, "installation_status.xml"));
	if (status == false)
	{
		if(l1) Log1(S("Opera.Updater.InstallationStatusNotFound"));
		return path;
	}
	var pos1 = status.indexOf("<path subfolder=\"");
	if (pos1 == -1)
	{
		return path;
	}
	status = status.substring(pos1);
	var pos2 = status.indexOf("\">");
	if (pos2 == -1)
	{
		return path;
	}
	var version = status.substring(17, pos2);
	path = Util.IO.CombinePath(path, version);
	return path;
}

Scenario.OperaUpdater = 
{
	name: 			"Opera.Updater",
	displayName:    "Opera 15 or Later",
	version: 		"1.0",
	description: 	"Allows to disable Opera 15 or latter updates",
	link:			"http://www.updatefreezer.org/index.php?id=35",
	icon:			"",
	actions:		["query", "backup", "restore", "enable", "disable"],

	programs:		[{path: "%PROGRAMFILES%\\Opera\\launcher.exe"}],
	inherits: 		[ScenarioController],
	
//#region Implementation
	_dataFileName: "Opera.json",
	_updaterPath: Util.IO.CombinePath(_GetOperaRootFolder(), "opera_autoupdate.exe"),
	_updaterPathDisabled: Util.IO.CombinePath(_GetOperaRootFolder(), "opera_autoupdate.exe_disabled"),
	_preferencesFile: Util.Shell.ExpandEnvironmentString("%USERPROFILE%\\AppData\\Roaming\\Opera Software\\Opera Stable\\Preferences"),
	
	_Query: function()
	{
		var result = {
			enabled: false
		};
		
		result.enabled = Util.IO.CheckDirectoryExists(this._updaterPath);
		
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this._dataFileName);
		Util.IO.WriteJsonToFile(dataFileName, result);
		
		if (result.enabled)
		{
			this.updaterEnabled = true;
			queryResult.push({msg: S("Opera.Updater.UpdaterEnabled")});
		}
		else
		{
			queryResult.push({msg: S("Opera.Updater.UpdaterDisabled")});
		}
		return result;
	},
	
	_Change: function(enable)
	{
		function ChangePreferences(path, enable)
		{
			// "last_check": "13022009829751829",
			// "next_check": "98117373838862747"		
			var timestamp = "98117373838862747"; // far future
			if (enable)
			{
				timestamp = "13022009829751829"; // in the past
			}
		
			var text = Util.IO.ReadFile(path);
			if (text == false)
			{
				if(l1) Log1(S("Opera.Updater.PreferencesNotFound"));
				return;
			}

			text = text.replace(new RegExp("(\"next_check\": \")[0-9]+", "g"), "$1" + timestamp);
			Util.IO.WriteFile(path, text);
		}
	
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this._dataFileName);
		var p = Util.IO.ReadJsonFromFile(dataFileName);
		if (p)
		{
			var et = enable;
			if (enable === undefined)
				et = p.enabled;
				
			if (et == false)
			{
				Util.IO.MoveFile(this._updaterPath, this._updaterPathDisabled);
			}
			else
			{
				Util.IO.MoveFile(this._updaterPathDisabled, this._updaterPath);			
			}
			ChangePreferences(this._preferencesFile, et);
		}
	},
//#endregion	

	
//#region Actions
	Query: function()
	{
		if (!this.CheckProgramInstalled())
		{
			return false;
		}	
	
		this._Query();
		this.LogUpdaterStatus();
	},
	
	Disable: function()
	{
		this._Change(false);
	},
	
	Enable: function()
	{
		this._Change(true);
	},
	
	Backup: function()
	{
		this._Query();
	},
	
	Restore: function()
	{
		this._Change();
	}
//#endregion	
	

};


Util.Scenario.InitializeScenario(Scenario.OperaUpdater);

if (typeof(g_executeInBatch) == "undefined")
{
	Util.Locale.Load();
	Execute(Scenario.OperaUpdater);
}

Scenario.OperaUpdater.OutputDependencies();
