/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/
 
if (typeof(g_executeInBatch) == "undefined")
{
	Include("Wrappers/Common.js")
	Include("Controllers/Controller.js");
}

if (typeof(Scenario) == "undefined")
	Scenario = {};


// Unofficial method: http://wpkg.org/Notepad_plus_plus
// Official method: http://superuser.com/questions/132797/disable-auto-update-in-notepad

Scenario.NppUpdater = 
{
	name: 			"Npp.Updater",
	displayName:    "Notepad++ 4.6 or Later",
	version: 		"1.0",
	description: 	"Allows to disable Notepad++ 4.6 or latter updates",
	link:			"http://www.updatefreezer.org/index.php?id=34",
	icon:			"",
	actions:		["query", "backup", "restore", "enable", "disable"],

	programs:		[{path: "%PROGRAMFILES%\\Notepad++\\notepad++.exe"}],
	inherits: 		[ScenarioController],
	
//#region Implementation
	nppDataFileName: "Npp.json",
	nppUpdaterPath: Util.Shell.ExpandEnvironmentString("%PROGRAMFILES%\\Notepad++\\updater"),
	nppUpdaterPathDisabled: Util.Shell.ExpandEnvironmentString("%PROGRAMFILES%\\Notepad++\\updater_disabled"),
	
	QueryNpp: function()
	{
		var result = {
			enabled: false
		};
		
		result.enabled = Util.IO.CheckDirectoryExists(this.nppUpdaterPath);
		
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.nppDataFileName);
		Util.IO.WriteJsonToFile(dataFileName, result);
		
		if (result.enabled)
		{
			this.updaterEnabled = true;
			queryResult.push({msg: S("Npp.Updater.UpdaterEnabled")});
		}
		else
		{
			queryResult.push({msg: S("Npp.Updater.UpdaterDisabled")});
		}
		return result;
	},
	
	ChangeNpp: function(enable)
	{
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.nppDataFileName);
		var p = Util.IO.ReadJsonFromFile(dataFileName);
		if (p)
		{
			var et = enable;
			if (enable === undefined)
				et = p.enabled;
				
			if (et == false)
			{
				Util.IO.MoveFile(this.nppUpdaterPath, this.nppUpdaterPathDisabled);
			}
			else
			{
				Util.IO.MoveFile(this.nppUpdaterPathDisabled, this.nppUpdaterPath);			
			}
		}
	},
//#endregion	

	
//#region Actions
	Query: function()
	{
		if (!this.CheckProgramInstalled())
		{
			return false;
		}	
	
		this.QueryNpp();
		this.LogUpdaterStatus();
	},
	
	Disable: function()
	{
		this.ChangeNpp(false);
	},
	
	Enable: function()
	{
		this.ChangeNpp(true);
	},
	
	Backup: function()
	{
		this.QueryNpp();
	},
	
	Restore: function()
	{
		this.ChangeNpp();
	}
//#endregion	
	

};


Util.Scenario.InitializeScenario(Scenario.NppUpdater);

if (typeof(g_executeInBatch) == "undefined")
{
	Util.Locale.Load();
	Execute(Scenario.NppUpdater);
}

Scenario.NppUpdater.OutputDependencies();
