/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/
 
if (typeof(g_executeInBatch) == "undefined")
{
	Include("Wrappers/Common.js")
	Include("Controllers/Controller.js");
}	

if (typeof(Scenario) == "undefined")
	Scenario = {};

	
Scenario.JavaUpdater = 
{
	name: 			"Java.Updater",
	displayName:    "Java",
	version: 		"1.0",
	description: 	"Checks if Java update is enabled and allows to disable and enable update facilities",
	link:			"http://www.updatefreezer.org/index.php?id=12",
	icon:			"Resources/Java.Updater.png",
	actions:		["query", "backup", "restore", "enable", "disable"],

	programs: [{path: "%PROGRAMFILES%\\Java"}, {path: "%PROGRAMW6432%\\Java"}],			
	registry:    [{section: Util.Registry.HKLM, key: "SOFTWARE\\JavaSoft\\Java Update\\Policy", value: "EnableJavaUpdate"},
				  {section: Util.Registry.HKLM, key: "SOFTWARE\\JavaSoft\\Java Update\\Policy", value: "EnableAutoUpdateCheck"},
				  {section: Util.Registry.HKLM, key: "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Update\\Policy", value: "EnableJavaUpdate"},
				  {section: Util.Registry.HKLM, key: "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Update\\Policy", value: "EnableAutoUpdateCheck"}],
	
	inherits: 	 [ScenarioController, RegistryController],
	
//#region Actions
	Query: function()
	{
		if (!this.CheckProgramInstalled())
		{
			return false;
		}	
	
		this.QueryRegistry(true);
		this.LogUpdaterStatus();
	},
	
	Disable: function()
	{
		this.ChangeRegistry(false);
	},
	
	Enable: function()
	{
		this.ChangeRegistry(true);
	},
	
	Backup: function()
	{
		this.QueryRegistry();
	},
	
	Restore: function()
	{
		this.ChangeRegistry();
	}
//#endregion		

		
};

Util.Scenario.InitializeScenario(Scenario.JavaUpdater);

if (typeof(g_executeInBatch) == "undefined")
{
	Util.Locale.Load();
	Execute(Scenario.JavaUpdater);
}

Scenario.JavaUpdater.OutputDependencies();
