/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/ 
 
if (typeof(g_executeInBatch) == "undefined")
{
	Include("Wrappers/Common.js")
	Include("Controllers/Controller.js");
}

if (typeof(Scenario) == "undefined")
	Scenario = {};
	
Scenario.GoogleUpdater = 
{
	name: 			"Google.Updater",
	displayName:    "Google",
	version: 		"1.4",
	description: 	"Checks if any of Google Update facilities are enabled and allows freezing of these facilities",
	link:			"http://www.updatefreezer.org/index.php?id=3",
	icon:			"Resources/Google.Updater.png",
	actions:		["query", "backup", "restore", "enable", "disable"],

	programs: [{path: "%PROGRAMFILES%\\Google\\Chrome\\Application\\chrome.exe"},
			   {path: "%USERPROFILE%\\AppData\\Local\\Google\\Chrome\\Application\\chrome.exe"},
			   {path: "%USERPROFILE%\\Local Settings\\Application Data\\Google\\Chrome\\Application\\chrome.exe"}],
	registry: [{section: Util.Registry.HKLM, key: "SOFTWARE\\Policies\\Google\\Update", value: "UpdateDefault"}],
	
	inherits: [ScenarioController, RegistryController],

//#region Actions
	Query: function()
	{
		if (!this.CheckProgramInstalled())
		{
			return false;
		}
		
		this.QueryRegistry(true);
		this.LogUpdaterStatus();
	},
	
	Disable: function()
	{
		this.ChangeRegistry(0);
	},
	
	Enable: function()
	{
		this.ChangeRegistry(1);
	},
	
	Backup: function()
	{
		this.QueryRegistry();
	},
	
	Restore: function()
	{
		this.ChangeRegistry();
	}
//#endregion	
	

};

Util.Scenario.InitializeScenario(Scenario.GoogleUpdater);

if (typeof(g_executeInBatch) == "undefined")
{
	Util.Locale.Load();
	Execute(Scenario.GoogleUpdater);
}

Scenario.GoogleUpdater.OutputDependencies();

