/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/ 
 
if (typeof(g_executeInBatch) == "undefined")
{
	Include("Wrappers/Common.js")
	Include("Controllers/Controller.js");
}

if (typeof(Scenario) == "undefined")
	Scenario = {};
	
Scenario.AppleUpdater = 
{
	name: 			"Apple.Updater",
	displayName:    "Apple",
	version: 		"1.0",
	description: 	"Checks if any of Apple Update facilities are enabled and allows freezing of these facilities",
	link:			"http://www.updatefreezer.org/index.php?id=30",
	icon:			"Resources/Apple.Updater.png",
	actions:		["query", "backup", "restore", "enable", "disable"],

	programs: [{path: "%PROGRAMFILES%\\Apple Software Update\\SoftwareUpdate.exe"}],
	tasks:	  [{name: "AppleSoftwareUpdate"}],
	
	inherits: [ScenarioController, TaskController],
	

//#region Actions
	Query: function()
	{
		if (!this.CheckProgramInstalled())
		{
			return false;
		}
		
		this.QueryTasks();
		this.LogUpdaterStatus();
	},
	
	Disable: function()
	{
		this.ChangeTasks(false);
		if (Util.Shell.IsVistaOrLater())
		{
			this.ChangeTasksTriggerType(this.TASK_TRIGGER_TIME);
		}
		else
		{
			this.ChangeTasksTriggerType(this.TASK_TIME_TRIGGER_ONCE);
		}
	},
	
	SetMonthly: function()
	{
		this.ChangeTasks(true);
		if (Util.Shell.IsVistaOrLater())
		{
			this.ChangeTasksTriggerType(this.TASK_TRIGGER_MONTHLY);
		}
		else
		{
			this.ChangeTasksTriggerType(this.TASK_TIME_TRIGGER_MONTHLYDATE);
		}
	},
	
	SetWeekly: function()
	{
		this.ChangeTasks(true);
		if (Util.Shell.IsVistaOrLater())
		{		
			this.ChangeTasksTriggerType(this.TASK_TRIGGER_WEEKLY);
		}
		else
		{
			this.ChangeTasksTriggerType(this.TASK_TIME_TRIGGER_WEEKLY);
		}
	},	
	
	SetDaily: function()
	{
		this.ChangeTasks(true);
		if (Util.Shell.IsVistaOrLater())
		{		
			this.ChangeTasksTriggerType(this.TASK_TRIGGER_DAILY);
		}
		else
		{
			this.ChangeTasksTriggerType(this.TASK_TIME_TRIGGER_DAILY);
		}
	},	
	
	Backup: function()
	{
		this.QueryTasks();
	},
	
	Restore: function()
	{
		this.ChangeTasks();
	},
//#endregion	


GetScenarioInfo: function()
	{
		Scenario.currentScenario = this;
		
		if (this.IsProgramInstalled)
		{
			if (false == this.IsProgramInstalled())
			{
					return {name: this.name, 
							displayName: this.displayName,
							icon: this.icon,
							status: S("UI.NotInstalled"),
							link: this.link};
			}
		}

		// do backup if first time
		var backupFolder = Util.Scenario.GetDataFolderPath(this.name, "backup");		
		var files = _GetFilesInFolder(backupFolder);
		if (files.length == 0)
		{
			action = "backup";
			Execute(this);
		}
	
		// do query
		this.updaterEnabled = false;
		action = "query";
		var status = Execute(this);
		
		// get current state of updates
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.GetTaskDataFileName());
		var result = Util.IO.ReadJsonFromFile(dataFileName);
		
		if (result == null)
		{
			return {name: this.name, 
			displayName: this.displayName,
			icon: this.icon,
			status: S("UI.NotInstalled"),
			link: this.link};
		}
		
		var state = false;
		if (result.values.length > 0)
		{
			state = result.values[0].TriggerType;
			if (result.values[0].Enabled == false)
			{
				state = false;
			}
		}
		
	
		var actionInfo = 
		{
			name: this.name,
			displayName: this.displayName,
			icon: this.icon,
			status: status,
			link: this.link,
		    actions: [
				{
					action: "Disable",
					buttonName: "Disabled",
					active: state == false
				},
				{
					action: "SetMonthly", 
					buttonName: "Monthly", 
					active: Util.Shell.IsVistaOrLater() ? state == "TASK_TRIGGER_MONTHLY" : state == "TASK_TIME_TRIGGER_MONTHLYDATE"
				},
				{
					action: "SetWeekly", 
					buttonName: "Weekly", 
					active: Util.Shell.IsVistaOrLater() ? state == "TASK_TRIGGER_WEEKLY" : state == "TASK_TIME_TRIGGER_WEEKLY"
				},
				{
					action: "SetDaily", 
					buttonName: "Daily", 
					active: Util.Shell.IsVistaOrLater() ? state == "TASK_TRIGGER_DAILY" : state == "TASK_TIME_TRIGGER_DAILY"
				}
			]
		};
	
		return actionInfo;
	}	
};

Util.Scenario.InitializeScenario(Scenario.AppleUpdater);

if (typeof(g_executeInBatch) == "undefined")
{
	Util.Locale.Load();
	Execute(Scenario.AppleUpdater);
}

Scenario.AppleUpdater.OutputDependencies();

