/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/ 

var TaskController = 
{
	// Task Scheduler 1
    TASK_TIME_TRIGGER_ONCE: 0,
	TASK_TIME_TRIGGER_DAILY: 1,
	TASK_TIME_TRIGGER_WEEKLY: 2,
	TASK_TIME_TRIGGER_MONTHLYDATE: 3,
	TASK_TIME_TRIGGER_MONTHLYDOW: 4,
	TASK_EVENT_TRIGGER_ON_IDLE: 5,
	TASK_EVENT_TRIGGER_AT_SYSTEMSTART: 6,
	TASK_EVENT_TRIGGER_AT_LOGON: 7,	

	// Task Scheduler 2
    TASK_TRIGGER_EVENT: 0,
	TASK_TRIGGER_TIME: 1,
	TASK_TRIGGER_DAILY: 2,
	TASK_TRIGGER_WEEKLY: 3,
	TASK_TRIGGER_MONTHLY: 4,
	TASK_TRIGGER_MONTHLYDOW: 5,
	TASK_TRIGGER_IDLE: 6,
	TASK_TRIGGER_REGISTRATION: 7,
	TASK_TRIGGER_BOOT: 8,
	TASK_TRIGGER_LOGON: 9,
	TASK_TRIGGER_SESSION_STATE_CHANGE: 11,

	GetTaskDataFileName: function()
	{
		return "Tasks.json";
	},
	
	HasTasks: function(result)
	{
		return result.values.length > 0;
	},
	
	HasEnabledTasks: function(result)
	{
		for(var i = 0; i < result.values.length; i++)
		{
			if (result.values[i].Enabled)
				return true;
		}
		return false;
	},	

	QueryTasks: function()
	{
	    var dataFileName = Util.IO.CombinePath(this.dataFolderPath, this.GetTaskDataFileName());
	
		var result = {
				values: []
			};
		
		
		var tasks = Util.Scheduler.EnumerateScheduledTasks();
		if (!tasks)
		{
			Error(S("Common.failedEnumerateScheduledTasks"));
			return result;
		}
		
		if (this.tasks)
		{
			for (var i = 0; i < this.tasks.length; i++)
			{
				var entry = this.tasks[i];	
		
				for(var j = 0; j < tasks.length; j++)
				{	
					var name = tasks[j].Task;
					if (name.indexOf(entry.name) != -1)
					{
						result.values.push(tasks[j]);
						if (l1) Log1(SF("Common.logTaskEnabled", [name, tasks[j].Enabled]));
					}
				}
			}
		}
		
		Util.IO.WriteJsonToFile(dataFileName, result);
		return result;	
	},
	
	ChangeTasks: function(enable)
	{
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.GetTaskDataFileName());
		var result = Util.IO.ReadJsonFromFile(dataFileName);
		if (result && result.values.length)
		{
			for(var i = 0; i < result.values.length; i++)
			{
				var task = result.values[i];
				
				var et = enable;
				if (enable === undefined)
					et = task.Enabled;
					
				if (Util.Scheduler.EnableScheduledTask(task.Folder, task.Task, et))
				{
					if(l1) Log1(SF("Common.taskChanged", [task.Task, et]));
				}
				else
				{
					Warning(SF("Common.failedChangeTask", [task.Task]));
				}
			}
		}
	},
	
	ChangeTasksTriggerType: function(triggerType)
	{
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.GetTaskDataFileName());
		var result = Util.IO.ReadJsonFromFile(dataFileName);
		if (result && result.values.length)
		{
			for(var i = 0; i < result.values.length; i++)
			{
				var task = result.values[i];
				
				var tt = triggerType;
				if (triggerType === undefined)
					tt = task.TriggerType;
					
				if (Util.Scheduler.SetTaskTriggerType(task.Folder, task.Task, tt))
				{
					if(l1) Log1(SF("Common.taskChanged", [task.Task, tt]));
				}
				else
				{
					Warning(SF("Common.failedChangeTask", [task.Task]));
				}
			}
		}
	},	
	
	LogTaskResult: function(result)
	{
		if (this.HasTasks(result))
		{
			if (this.HasEnabledTasks(result))
			{
				this.updaterEnabled = true;
				queryResult.push({msg: S("Common.TasksEnabled")});
			}
			else
				queryResult.push({msg: S("Common.TasksDisabled")});
		}
		else
		{
			queryResult.push({msg: S("Common.TasksNotInstalled")});
		}
	}
}