/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/ 

var ServiceController = 
{
	GetServiceDataFileName: function()
	{
		return "Services.json";
	},
	
	HasInstalledServices: function(result)
	{
		for(var i = 0; i < result.values.length; i++)
		{
			if (result.values[i].exists)
				return true;
		}		
		return false;		
	},
	
	HasRunningServices: function(result)
	{
		for(var i = 0; i < result.values.length; i++)
		{
			if (result.values[i].running)
				return true;
		}		
		return false;
	},
	
	HasEnabledServices: function(result)
	{
		for(var i = 0; i < result.values.length; i++)
		{
			if (result.values[i].startType < Util.Service.StartType.SERVICE_DEMAND_START)
				return true;
		}		
		return false;			
	},	

	QueryServices: function()
	{
	    var dataFileName = Util.IO.CombinePath(this.dataFolderPath, this.GetServiceDataFileName());
	
		var result = {
				values: []
			};
		
		if (this.services)
		{
			for (var i = 0; i < this.services.length; i++)
			{
				var entry = this.services[i];
				var service = Util.Service.QuerySvc(entry.name);
				
				if (l1) Log1(SF("Common.logServiceExists", [entry.name, service ? true : false]));
				
				if (service)
				{
					service["exists"] = true;
					result.values.push(service);
					if (l1) Log1(SF("Common.logServiceEnabled", [entry.name, service.startType < Util.Service.StartType.SERVICE_DEMAND_START]));
					if (l1) Log1(SF("Common.logServiceRunning", [entry.name, service.running]));
				}
				else
				{
					result.values.push({name: entry.name, exists: false});
				}
			}
		}
		
		Util.IO.WriteJsonToFile(dataFileName, result);
		return result;
	},
	
	ChangeServices: function(startType)
	{
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.GetServiceDataFileName());
		var result = Util.IO.ReadJsonFromFile(dataFileName);
		if (result && result.values.length)
		{
			for(var i = 0; i < result.values.length; i++)
			{
				var service = result.values[i];
				
				var name = service.name;
				var st = startType;
				if (startType === undefined)
					st = service.startType;
					
				if (Util.Service.ChangeSvcStartType(name, st))
					if(l1) Log1(SF("Common.serviceChanged", [name, st]));
				else
					Warning(SF("Common.failedToChangeService", [name]));
				
				var start = false;
				var startText = SF("Common.serviceStopped", [name]);
				if (st == Util.Service.StartType.SERVICE_AUTO_START)
				{
					start = true;
					startText = SF("Common.serviceStarted", [name]);
				}
				
				if (Util.Service.StartService(name, start))
				{
					if(l1) Log1(startText);	
				}
				else
				{
					var errorText = SF("Common.failedStopService", [name]);
					if (start)
						errorText = SF("Common.failedStartService", [name]);						
					
					Warning(errorText);
				}					
			}
		}
	},
	
	LogServiceResult: function(result)
	{
		if (this.HasInstalledServices(result))
		{
			if (this.HasRunningServices(result))
			{
				this.updaterEnabled = true;
				queryResult.push({msg: S("Common.ServiceRunning")});
			}
			else
				queryResult.push({msg: S("Common.ServiceStopped")});
		
			if (this.HasEnabledServices(result))
			{
				this.updaterEnabled = true;
				queryResult.push({msg: S("Common.ServiceEnabled")});
			}
			else
				queryResult.push({msg: S("Common.ServiceDisabled")});	
		}
		else
		{	
			queryResult.push({msg: S("Common.ServiceNotInstalled")});
		}	
	}
}