/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/ 

if (typeof(ProgramController) == "undefined")
{
	Include("Controllers/Program.Controller.js");
}

var ScenarioController = 
{
	inherits: [ProgramController],

	imageMap:   {
				},
	
	dataFolderPath: null,
	updaterEnabled: false,
	
	LogUpdaterStatus: function()
	{
		if (this.updaterEnabled)
		{
			queryResult.push({msg: "<b>" + S(this.name + ".UpdaterEnabled") + "</b>"});
		}
		else
		{
			queryResult.push({msg: "<b>" + S(this.name + ".UpdaterDisabled") + "</b>"});
		}
	},
	
	CheckProgramInstalled: function()
	{
		if (this.IsProgramInstalled)
		{
			if (false == this.IsProgramInstalled())
			{
				queryResult.push({msg: "<b>" + S("UI.NotInstalled") + "</b>"});
				return false;
			}
		}	
		return true;
	},

	GetScenarioInfo: function()
	{
		Scenario.currentScenario = this;
		
		if (this.IsProgramInstalled)
		{
			if (false == this.IsProgramInstalled())
			{
					return {name: this.name, 
							displayName: this.displayName,
							icon: this.icon,
							status: S("UI.NotInstalled"),
							link: this.link};
			}
		}

		// do backup if first time
		var backupFolder = Util.Scenario.GetDataFolderPath(this.name, "backup");		
		var files = _GetFilesInFolder(backupFolder);
		if (files.length == 0)
		{
			action = "backup";
			Execute(this);
		}
	
		// do query
		this.updaterEnabled = false;
		action = "query";
		var status = Execute(this);
		
		var updaterEnabled = this.updaterEnabled;
		var actionInfo = 
		{
			name: this.name,
			displayName: this.displayName,
			icon: this.icon,
			status: status,
			link: this.link,
		    actions: [
				{
					action: "disable",
					buttonName: "Disabled",
					buttonIcon: this.imageMap["Disable.png"],
					active: updaterEnabled != true
				},
				{
					action: "enable", 
					buttonName: "Enabled", 
					buttonIcon: this.imageMap["Enable.png"],
					active: updaterEnabled == true
				}
			]
		};
	
		return actionInfo;
	},

	OutputDependencies: function()
	{
		if(typeof(_dependencies)!="undefined")
		{
			// image map
			var imageMap = this.imageMap;
			for (var img in imageMap)
			{
				var path = imageMap[img];
				_dependencies[img] = {name: img, path: Util.IO.GetCurrentDirectory() + "/" + path};
			}
			
			// icon
			//_dependencies[this.icon] = {name: this.icon, path: Util.IO.GetCurrentDirectory() + "/" + this.icon};
			
			// locale
			Util.Locale.OutputDependencies(this.name);
			
			// scenario info
			_dependencies.startup = _dependencies.startup||{};
			_dependencies.startup.scenarioName = this.name;
			_dependencies.startup.version = this.version;	
			_dependencies.startup.description = this.description;
			_dependencies.startup.author = this.author;
			_dependencies.startup.icon = this.icon;			
		}	
	}
};