/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/ 

var RegistryController = 
{
	GetRegistryDataFileName: function()
	{
		return "Registry.json";
	},
	
	QueryRegistry: function(logResult)
	{
		if(l1) Log1(S("Common.logCheckingRegistry"));
		var dataFileName = Util.IO.CombinePath(this.dataFolderPath, this.GetRegistryDataFileName());
		
		var result = {
				values: []
  			 };

		if (this.registry)
		{
			for (var i = 0; i < this.registry.length; i++)
			{
				var entry = this.registry[i];
				var data = null;
				if (Util.Registry.IsKeyValueExists(entry.section, entry.key, entry.value))
				{
					data = Util.Registry.GetKeyValueDWORD(entry.section, entry.key, entry.value);
				}
				result.values.push(
					{
						section: entry.section,
					 	key: entry.key,
					  	value: entry.value,
					  	data: data
					}
				);
				if (l1) Log1(SF("Common.logRegistryValue", [entry.value, data]));
			}
		}
		
		Util.IO.WriteJsonToFile(dataFileName, result);
		
		if (logResult)
			this.LogRegistryResult(result);
		
		return result;
	},
	
	ChangeRegistry: function(data)
	{
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.GetRegistryDataFileName());
		var result = Util.IO.ReadJsonFromFile(dataFileName);
		if (result && result.values.length)
		{
			for(var i = 0; i < result.values.length; i++)
			{
				var value = result.values[i];
					
				if (!Util.Registry.EnsureKeyExists(value.section, value.key))
				{
					Error(SF("Common.failedCreateRegistryKey", [value.section + "\\" + value.key]));
					return false;
				}
				
				var dt = data;
				if (dt == undefined)
					dt = value.data;
					
				if (Util.Registry.SetKeyValueDWORD(value.section, value.key, value.value, dt))
				{
					if(l1) Log1(SF("Common.registryValueChanged", [value.value, dt]));
				}
				else
				{
					Error(SF("Common.failedChangeRegistryValue", [value.value]));
				}
			}
		}	
	},
	
	LogRegistryResult: function(result)
	{
  		function IsEnabled(result)
		{
			for(var i = 0; i < result.values.length; i++)
			{
				if (result.values[i].data == 1 || result.values[i].data == null)
					return true;
			}
			return false;
		}
		
		if (IsEnabled(result))
		{
			this.updaterEnabled = true;
			queryResult.push({msg: S("Common.RegistryEnabled")});
		}
		else
		{
			queryResult.push({msg: S("Common.RegistryDisabled")});
		}	
	}
};