/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/ 

var PolicyController = 
{
	GetPolicyDataFileName: function()
	{
		return "Policy.json";
	},
	
	HasPFiles: function(result)
	{
		for(var i = 0; i < result.values.length; i++)
		{
			if (result.values[i].exists)
				return true;
		}
		return false;
	},
	
	HasEnabledPFiles: function(result)
	{
		for(var i = 0; i < result.values.length; i++)
		{
			if (result.values[i].enabled)
				return true;
		}
		return false;
	},	

	QueryFilePolicy: function()
	{
	    var dataFileName = Util.IO.CombinePath(this.dataFolderPath, this.GetPolicyDataFileName());
	
		var result = {
				values: []
			};
		
		for(var i = 0; i < this.policyFiles.length; i++)
		{
			var entry = this.policyFiles[i];
			var path = Util.Shell.ExpandEnvironmentString(entry.path);
			var exists = Util.IO.CheckFileExists(path);
			var enabled = true;
			if(exists)
			{
				var policy = Util.GroupPolicy.QueryPathRestrictionPolicyLevel(path);
				if(policy ==  Util.GroupPolicy.GPO_LEVEL_DISALLOWED)
					enabled = false;
			}

			result.values.push(
				{
					name: entry.name,
					path: path,
					exists: exists,
					enabled: enabled,
					policy: policy
				}
			);
			
			if (l1) Log1(SF("Common.logFilePolicy", [entry.name, policy]));
		}
	
		Util.IO.WriteJsonToFile(dataFileName, result);
		return result;	
	},
	
	ChangeFilePolicy: function(enable)
	{
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.GetPolicyDataFileName());
		var result = Util.IO.ReadJsonFromFile(dataFileName);
		if (result && result.values.length)
		{
			for(var i = 0; i < result.values.length; i++)
			{
				var entry = result.values[i];
				
				var policy = enable ? Util.GroupPolicy.GPO_LEVEL_DELETE : Util.GroupPolicy.GPO_LEVEL_DISALLOWED;
				if (enable === undefined)
					policy = entry.policy;
					
				var level = Util.GroupPolicy.SetPathRestrictionPolicy(entry.path, policy);
				
				if (l1) Log1(SF("Common.logFilePolicy", [entry.name, level]));
			}
		}
	},
	
	LogFilePolicyResult: function(result)
	{
		if(this.HasPFiles(result))
		{
			if(this.HasEnabledPFiles(result))
			{
				this.updaterEnabled = true;
				queryResult.push({msg: S("Common.FilesEnabled")});
			}
			else
			{
				queryResult.push({msg: S("Common.FilesDisabled")});
			}
		}
		else
		{
			queryResult.push({msg: S("Common.FilesNotFound")});
		}
	}
}