/************************************************************************ 
  Copyright 2011-2012, IceJS Team. All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:
  
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of Update Freezer Team nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***********************************************************************/ 

var FileController = 
{
	GetFileDataFileName: function()
	{
		return "Files.json";
	},
	
	HasFiles: function(result)
	{
		for(var i = 0; i < result.values.length; i++)
		{
			if (result.values[i].exists)
				return true;
		}
		return false;
	},

	QueryFiles: function()
	{
		var dataFileName = Util.IO.CombinePath(this.dataFolderPath, this.GetFileDataFileName());
	
		var result = {
				values:[]
			};
		
		if (this.files)
		{
			for (var i = 0; i < this.files.length; i++)
			{
				var entry = this.files[i];
				var path = Util.Shell.ExpandEnvironmentString(entry.path);
		 		var exists = Util.IO.CheckFileExists(path);

				if (l1) Log1(SF("Common.logFileExists", [path, exists]));

				result.values.push(
					{
						name: entry.name, 
						path: path, 
						exists: exists
					});
			}
		}
		
		Util.IO.WriteJsonToFile(dataFileName, result);
		return result;		
	},
	
	ChangeFiles: function(enable)
	{
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.GetFileDataFileName());
		var result = Util.IO.ReadJsonFromFile(dataFileName);
		if (result && result.values.length)
		{
			for(var i = 0; i < result.values.length; i++)
			{
				var file = result.values[i];
					
				var et = enable;
				if (enable === undefined)
				{
					et = file.exists;
				}
		
				var src = "";
				var dst = "";
				if (et)
				{
					src = Util.IO.CombinePath(this.dataFolderPath, file.name);
					dst = file.path; 
				}
				else
				{
					src = file.path;
					dst = Util.IO.CombinePath(this.dataFolderPath, file.name);
				}
		
				if (Util.IO.CheckFileExists(src))
				{
					if (Util.IO.CheckFileExists(dst))
					{
						if (Util.IO.DeleteFile(dst) == false)
						{
							if(l0) Log("Failed to delete: " + dst);
						}
					}
					
					if (Util.IO.MoveFile(src, dst))
					{
						if(l1) Log1("File " + src + " copied successfully");
					}
					else
						Warning("Failed to move " + src);
				}
				else
				{
					if(l2) Log2("File " + src + " does not exist");
				}			
			}
		}		
	},
	
	BackupFiles: function()
	{
		var dataFileName =  Util.IO.CombinePath(this.dataFolderPath, this.GetFileDataFileName());
		var result = Util.IO.ReadJsonFromFile(dataFileName);
		if (result && result.values.length)
		{
			for(var i = 0; i < result.values.length; i++)
			{
				var file = result.values[i];
					
				var src = file.path;
				var	dst = Util.IO.CombinePath(this.dataFolderPath, file.name);
		
				if (Util.IO.CheckFileExists(src))
				{
					if (Util.IO.CheckFileExists(dst))
					{
						if (Util.IO.DeleteFile(dst) == false)
						{
							if(l0) Log("Failed to delete: " + dst);
						}
					}

					if (Util.IO.CopyFile(src, dst))
					{
						if(l1) Log1("File " + src + " copied successfully");
					}
					else
						if(l0) Log0("Failed to copy " + src);
				}
			}
		}	
	},
	
	LogFileResult: function(result)
	{
		if (this.HasFiles(result))
		{
			this.updaterEnabled = true;
			queryResult.push({msg: S("Common.FilesFound")});
		}
		else
			queryResult.push({msg: S("Common.FilesNotFound")});	
	}
}